#include <Wire.h>
#include "ShutterDef.h"

// Adresse esclave I2C
//#define SLAVE_ADDRESS 0x11
//#define SLAVE_ADDRESS 0x12
//#define SLAVE_ADDRESS 0x13
#define SLAVE_ADDRESS 0x14

bool debug = false;
ShutterDef volets[] = { {7, 6, 10, 11, 0, 0}, {9, 8, 12, 13, 0, 0} };

void setup() {
  // Initialisation des relais en output et des input en pull-up.
  for (int i = 0; i < (sizeof(volets)/sizeof(ShutterDef)); i++) 
  {
    pinMode(volets[i].relaisMontee, OUTPUT);
    pinMode(volets[i].relaisDescente, OUTPUT);
    
    pinMode(volets[i].buttonMontee, INPUT_PULLUP); 
    pinMode(volets[i].buttonDescente, INPUT_PULLUP);
  } 
  
  Serial.begin(9600);
  Wire.begin(SLAVE_ADDRESS);
  Wire.onReceive(receiveData);
  Wire.onRequest(sendData);    
}

void loop() 
{  
  for (int i = 0; i < (sizeof(volets)/sizeof(ShutterDef)); i++) 
  {    
    // Si le bouton est appuye, alors on affecte la montee. Sinon, le fonctionnement reste nominal.
    if (digitalRead(volets[i].buttonMontee) == LOW 
        && volets[i].previousSens != 1)
    {
      volets[i].sens = 1;
      volets[i].previousSens = volets[i].sens;
    } 
    if (digitalRead(volets[i].buttonDescente) == LOW 
        && volets[i].previousSens != -1)
    {
      volets[i].sens = -1;
      volets[i].previousSens = volets[i].sens;
    } 
    
    if (digitalRead(volets[i].buttonDescente) == HIGH 
        && digitalRead(volets[i].buttonMontee) == HIGH 
        && volets[i].previousSens != 0)
    {
      volets[i].sens = 0;  
      volets[i].previousSens = volets[i].sens;
    }
    
    // Affectation aux relais selon le sens demande.
    if (volets[i].sens > 0)
    {
        digitalWrite(volets[i].relaisMontee, HIGH);
        digitalWrite(volets[i].relaisDescente, LOW); 
    }
    
    if (volets[i].sens == 0)
    {
        digitalWrite(volets[i].relaisMontee, LOW); 
        digitalWrite(volets[i].relaisDescente, LOW); 
    }  
    
    if (volets[i].sens < 0)
    {
        digitalWrite(volets[i].relaisDescente, HIGH);
        digitalWrite(volets[i].relaisMontee, LOW); 
    } 
    
    if(debug)
    {
      String message = "/";
      message += i;
      if(volets[i].sens > 0)
        message += ": Ouverture ";
      if(volets[i].sens == 0)
        message += ": Arret ";
      if(volets[i].sens < 0)
        message += ": Fermeture ";
          
      Serial.print(message);
    }
  }
  
  if(debug)    
    Serial.println("");
      
  delay(50); // pause de 50 ms 
}


void receiveData(int byteCount)
{
  // Reception de donnees via le bus I2C.
  String rawVal;
  
  while(Wire.available()) 
  {
    int dataReceived = 0;
    dataReceived = Wire.read();
    rawVal += dataReceived;
    
    if(debug)
    {
      Serial.print("rawVal : ");
      Serial.println(rawVal);
    }
  }
  
  int rawInt = rawVal.toInt();
  int numVolet = bitRead(rawInt,2);
  int allumageVolet = bitRead(rawInt,1);
  int sensVolet = bitRead(rawInt,0);
     
  if(debug)
  {
    Serial.print("valeur entiere : ");
    Serial.println(rawInt);
    
    Serial.print("valeur binaire : ");
    Serial.print(bitRead(rawInt,2)); 
    Serial.print(bitRead(rawInt,1)); 
    Serial.print(bitRead(rawInt,0));
    Serial.println(""); 
    
    Serial.print("Numero de volet : ");
    Serial.println(numVolet); 
    Serial.print("Marche (1) ou arret (0) : ");
    Serial.println(allumageVolet); 
    Serial.print("Sens : ouverture (1) ou fermeture (0) : ");
    Serial.println(sensVolet); 
  }
  
  // Exemples de format :
  // 0	  volet n°0 à l'arrêt	0	0x00
  // 1    volet n°0 à l'arrêt	1	0x01
  // 10	  volet n°0 en descente	2	0x02
  // 11	  volet n°0 en montée	3	0x03
  // 100  volet n°1 à l'arrêt	4	0x04
  // 101  volet n°1 à l'arrêt	5	0x05
  // 110  volet n°1 en descente	6	0x06
  // 111  volet n°1 en montée	7	0x07
  
  /*
  X-- -> Numéro de volet (0 ou 1)
  -X- -> Activation du volet (1=activé)
  --X -> Sens du volet (0=descente/fermeture, 1=montée/ouverture)
  */

  if(allumageVolet == 1)
  {
    if(sensVolet == 1)
      volets[numVolet].sens = 1;
    else
      volets[numVolet].sens = -1;
  }
  else
  {
    volets[numVolet].sens = 0;
  }

}

void sendData()
{  
  int retour;  
  
  /*
  X--- -> Activation du volet 0 (1=activé)
  -X-- -> Sens du volet 0 (0=descente/fermeture, 1=montée/ouverture)
  --X- -> Activation du volet 1 (1=activé)
  ---X -> Sens du volet 1 (0=descente/fermeture, 1=montée/ouverture)
  */
  
  if(volets[0].sens == 0)
    bitWrite(retour, 3, 0);
  else
  {
    bitWrite(retour, 3, 1);
    
    if(volets[0].sens > 0)
      bitWrite(retour, 2 , 1);
    else if(volets[0].sens < 0)
      bitWrite(retour, 2, 0);
  }
  
  if(volets[1].sens == 0)
    bitWrite(retour, 1, 0);
  else
  {
    bitWrite(retour, 1, 1);
    
    if(volets[1].sens > 0)
      bitWrite(retour, 0 , 1);
    else if(volets[1].sens < 0)
      bitWrite(retour, 0, 0);
  }
  
  Wire.write(retour);
}
